% esempio di utilizzo di un comb per recuperare un onda quadra (di data
% frequenza) da notare che qualora si cambi frequenza del segale originale
% ovviamente il filtro non gli va dietro e si percepisce sempre la stessa
% nota (sintetizzatore di trombe)


L=16
wo=0;
dw=pi/16;

r=1-(dw/2);
G=(1-r)*sqrt(1+r*r-2*r*cos(2*wo))

num=[0 0 G];
den=conv([1 -r*exp(j*wo)],[1 -r*exp(-j*wo)]);

num=aggiungi_zeri(num,L);
den=aggiungi_zeri(den,L);

zplane(num,den);pause;
%[h,w]=freqz(num,den);plot(w,abs(h));
freqz(num,den);

%  Prova audio

N=16000;
w=pi/6;
f=0;
%onda quadra + noise
x=1:N;
y=sin(w*x+f)*1000;
y(y>1)=1;y(y<-1)=-1;
soundsc(y);pause;
noise=(rand(1,N)-.5)*2;
y=y+noise;
% originale
soundsc(y);pause
out=filter(num,den,y);
soundsc(out);

% plot

plot(10000:10100,y(10000:10100),10000:10100,out(10000:10100));


