% creazione di un filtro passa-basso  a fase lineare
% con la tecnica del campionamento
% in frequenza e sulla usando i coseni
clear all;

g=[1 -1 1  0 0 0 0 ];
[qq,len]=size(g);

ncamp=2*len;        % se si vogliono un numero pari di campioni
%ncamp=2*len+1;      % se si vuole un numero dispari di campioni

for n=0:ncamp-1;
    h(n+1)=g(1)
    for k=1:len-1;
        h(n+1)=h(n+1)+2*g(k+1)*cos(pi*k*(2*n+1)/ncamp)
    end
end
h=h/ncamp;


%%%%%%%%%%%%%%%plot %%%%%%%%%%%%%%%
subplot(2,1,1);
stem(h)
subplot(2,1,2);
[amp,pul]=freqz(h);
assex=[0:len-1]*2*pi/ncamp;
plot(pul,abs(amp),assex,abs(g),'ro');


