% Esempio di progetto completo di un filtro passa-banda
% usando la trasformata BILINEARE

% specifiche
Fs=44000;Rs=40;Rp=3;

% calcolo Parmametri
A=10^(Rs/20)
ep=(sqrt(10^(Rp/10)-1))

T=1/Fs  %% fa cambiare solamente il fattore di scala del filtro analogico da progettare

% Specifiche analogiche
f=[2000 4000 8000 16000 Fs/2]

% specifiche del filtro analogico da realiazzare
wn=2/T*tan(pi*f/Fs) %%%% utilizzando la predistorsione

% calcolo delle specifiche del prototipo
wl=wn(2);wu=wn(3);
s(1)=abs((wl*wu-wn(1)*wn(1))/(wn(1)*(wu-wl)));
s(2)=abs((wl*wu-wn(2)*wn(2))/(wn(2)*(wu-wl)));
s(3)=abs((wl*wu-wn(3)*wn(3))/(wn(3)*(wu-wl)));
s(4)=abs((wl*wu-wn(4)*wn(4))/(wn(4)*(wu-wl)));
s

% ordine del prototipo
n=acosh(sqrt((A*A-1))/ep)/acosh(min([s(1),s(4)]))
n=ceil(n)

% progetto del prototipo
[a,b]=cheby1(n,Rp,s(2),'s');
%[a,b]=cheby2(n,Rs,min([s(1),s(4)]),'s');
[h,w]=freqs(a,b);plot(w,abs(h));pause;

% realizzazione del passabanda
[a,b]=poly_subs(a,b,[1 0 wu*wl],[wu-wl 0]);
[h,w]=freqs(a,b);plot(w,abs(h));pause;

% applicazione della bilineare
[az,bz]=poly_subs(a,b,[2/T -2/T],[1 1]);
[h,w]=freqz(az,bz);plot(w,abs(h));pause;
plot(w,20*log10(abs(h)));





