%%%%%%%%%%% Specifiche %%%%%%%%%%%

wp=400;
ws=1000;
rp=2;
rs=30;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ep=sqrt((10^(abs(rp)/10)-1));
A=sqrt(10^(abs(rs)/10));
d=1/sqrt((1+ep*ep));
eta=sqrt(A*A-1)/ep;

n=acos(eta)/acos(ws/wp);
n=ceil(n)

%n=7

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% calcolo del primo filtro
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pol=chebcoeff(n)
pol2=conv(pol,pol)

num=pol;
den=pol2+[zeros(1,2*n),1]*ep*ep*polyval(pol2,ws/wp);

zeri=1./roots(num)*i;
poli=1./roots(den)*i;

poli=poli(real(poli)<0);
zplane(zeri,poli);pause;

wt=ws;

a=poly(zeri*wt);
b=poly(poli*wt);
[h1,w]=freqs(a,b,[1:2000]);
h1=h1/h1(1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% calcolo del secondo filtro
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pol=chebcoeff(n)
pol2=conv(pol,pol)

num=pol;
den=pol2+[zeros(1,2*n),1]*(A*A-1);

zeri=1./roots(num)*i;
poli=1./roots(den)*i;

poli=poli(real(poli)<0);
zplane(zeri,poli);pause;

wt=ws;

a=poly(zeri*wt);
b=poly(poli*wt);
[h2,w]=freqs(a,b,[1:2000]);
h2=h2/h2(1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% calcolo del terzo filtro
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pol=chebcoeff(n)
pol2=conv(pol,pol)

num=pol;
den=pol2+[zeros(1,2*n),1]*(A*A-1);

zeri=1./roots(num)*i;
poli=1./roots(den)*i;

poli=poli(real(poli)<0);
zplane(zeri,poli);pause;

wt=wp*(cosh(acosh(eta)/n));

a=poly(zeri*wt);
b=poly(poli*wt);
[h3,w]=freqs(a,b,[1:2000]);
h3=h3/h3(1);



% plot

plot([1,wp,wp],[d,d,0],'r:');hold
plot([0,ws,ws,2000],[1,1,1/A,1/A],'r:');
plot(w,abs(h1),w,abs(h2),w,abs(h3));hold;

axis([0, 2000, 0, 1.05]);

