%%%%%%%%%%% Specifiche %%%%%%%%%%%

wp=400;
ws=1000;
rp=2;
rs=30;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ep=sqrt((10^(abs(rp)/10)-1));
A=sqrt(10^(abs(rs)/10));
d=1/sqrt((1+ep*ep));
eta=sqrt(A*A-1)/ep;

n=acos(eta)/acos(ws/wp);
n=ceil(n)

wtd=ws
wts=wp*(cosh(acosh(eta)/n))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% calcolo dei poli del prototipo
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pol=chebcoeff(n)
pol2=conv(pol,pol)

num=pol;
den=pol2+[zeros(1,2*n),1]*(A*A-1);

zeri=1./roots(num)*i;
poli=1./roots(den)*i;

poli=poli(real(poli)<0);
zplane(zeri,poli);pause;


% filtro sinistro

a=poly(zeri*wts);
b=poly(poli*wts);
[hs,w]=freqs(a,b,[1:2000]);
hs=hs/hs(1);

% filtro destro

a=poly(zeri*wtd);
b=poly(poli*wtd);
[hd,w]=freqs(a,b,[1:2000]);
hd=hd/hd(1);

% plot

plot([1,wp,wp],[d,d,0],'r:');hold
plot([0,ws,ws,2000],[1,1,1/A,1/A],'r:');
plot(w,abs(hs),w,abs(hd));hold;

axis([0, 2000, 0, 1.05]);

