clear all
%%%%%%%%%%% Specifiche %%%%%%%%%%%

wp=1;
ws=2;
rp=3;
rs=20;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ep=sqrt((10^(abs(rp)/10)-1));
A=sqrt(10^(abs(rs)/10));
d=1/sqrt((1+ep*ep));
eta=sqrt(A*A-1)/ep;

n=3

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% calcolo del primo filtro
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

wp=1;

pol=chebcoeff(n)
pol2=conv(pol,pol)

ep=sqrt((A*A-1)/(polyval(pol2,ws/wp)));

num=1;
den=[zeros(1,2*n) 1]+ep*ep*pol2

zeri=roots(num)*i;
poli=roots(den)*i;
poli=poli(real(poli)<0);
zplane(zeri,poli);pause;


wc=wp;

a=poly(zeri*wc);
b=poly(poli*wc);
[h1,w]=freqs(a,b,[0:0.01:4]);
h1=h1/h1(1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% calcolo del secondo filtro
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

wp=1.2;

pol=chebcoeff(n)
pol2=conv(pol,pol)

ep=sqrt((A*A-1)/(polyval(pol2,ws/wp)));

num=1;
den=[zeros(1,2*n) 1]+ep*ep*pol2

zeri=roots(num)*i;
poli=roots(den)*i;
poli=poli(real(poli)<0);
zplane(zeri,poli);pause;


wc=wp;

a=poly(zeri*wc);
b=poly(poli*wc);
[h2,w]=freqs(a,b,[0:0.01:4]);
h2=h2/h2(1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% calcolo del terzo filtro
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

wp=1.4;

pol=chebcoeff(n)
pol2=conv(pol,pol)

ep=sqrt((A*A-1)/(polyval(pol2,ws/wp)));

num=1;
den=[zeros(1,2*n) 1]+ep*ep*pol2

zeri=roots(num)*i;
poli=roots(den)*i;
poli=poli(real(poli)<0);
zplane(zeri,poli);pause;


wc=wp;

a=poly(zeri*wc);
b=poly(poli*wc);
[h3,w]=freqs(a,b,[0:0.01:4]);
h3=h3/h3(1);


% plot

%plot([0,wp,wp],[d,d,0],'r:');hold
plot([0,ws,ws,4],[1,1,1/A,1/A],'m:');hold;
plot(w,abs(h1),w,abs(h2),w,abs(h3));hold;

axis([0, 4, 0, 1.05]);

