; --------------------------------------------------------------
;Program to control conveyor belt
; --------------------------------------------------------------
$MOD52

$TITLE(CONVEYOR BELT)


		MOV		SP,#20h			;Move SP beyond registers

		MOV		P1,#00h			;Clear control out for conveyor
		MOV		P2,#00h			;Clear control in for conveyor
		MOV		P3,#0FFh		;Default for ext ports are already high
								;Need to ensure that ~Enable remains high

BEGIN:
		;Start with a bit of a delay
		LCALL	DELAY			;Delay for a bit
		LCALL	FWD				;Set Package moving forward


MAIN1:							;Main1 loop
		JB		P0.2, CONT1		;Go drop some balls into package
		JMP		MAIN1

MAIN2:							;Main2 loop
		JB		P0.3, CONT2		;Stop the package
		JMP		MAIN2

		
CONT1:
		LCALL	DROPB			;Drop the balls
		LCALL	FWD				;Start up again
		JMP		MAIN2			;Go back to begin
	
CONT2:
		LCALL	STOP			;Stop the package

	
		JMP		HALT			;finish the program


DELAY:
		MOV		PSW,#18h		;Move to register bank 3
		MOV		R7,#0FFh		;loop register

LOOP:	DJNZ 	R7,LOOP			;Loop back
		MOV		PSW,#00h		;Move to register bank 0
		RET						;return	from delay sub


FWD:	CLR		P1.0			;Off "Drop"	
		CLR		P1.1			;Off "Stop"
		CLR		P1.2			;Off "Rev"
		SETB	P1.3			;On  "FWD"
		LCALL	DELAY			;delay
		CLR 	P1.3			;Off "FWD"
		RET


DROPB:		
		CLR		P1.3			;Off "FWD"
		SETB	P1.1			;ON  "Stop"
		CLR		P1.2			;Off "Rev"
		SETB	P1.0			;On  "Drop"
		CLR		P3.0			;This will enable the dropping mechanism
		LCALL	DELAY			;some delay
		SETB	P3.0			;Disable dropping mechanism
		CLR		P1.0			;Off "Drop"
		CLR		P1.1			;Off "Stop"
		RET

STOP:		
		SETB	P1.1			;ON  "Stop"
		RET
		
HALT:	JMP	HALT				;finish the spin

END
