; MCU Co-Sim Test Program Suite
; Character echo program using interrupts 
; Copyright 2005 Electronics Workbench Inc.
$MOD52

$TITLE(ECHO ISR)

; Characters are received on the RxD pin of the mcu
; at a baud rate of 1.2K using serial communication
; mode 1 when the program is run.  The 1.2K baud rate
; is achieved by using timer 1 in 8-bit auto reload
; mode where the reload value is E5H.
; Characters received on pin RxD are echoed out through
; the TxD pin.  The code for echoing the characters is
; contained in the serial interrupt service routine
; and is executed every time a whole character (a start 
; bit, 8 data bits and a stop bit) is received.

; In order to send and receive characters to the mcu,
; a virtual terminal can be hooked up to the RxD and
; Txd pins.

; Program start

; start timer 1 and then start serial rx in mode 1
	CLR	RCLK		; rx uses timer 1
	MOV	TMOD, #020H	; 8-bit auto reload
	MOV 	TH1, #0E5H	; 1.2K baud rate 
	MOV	TL1, #0E5H
	SETB	TR1		; start timer 1
	CLR	SM0		; set serial mode to 1
	SETB	SM1
	CLR	RI
	SETB	REN

	SETB	ES		; enable serial interrupt
	SETB	EA		; enable interrupts in general

endloop:
	JMP endloop

	ORG	0023H		; serial ISR address
	LJMP	int_serial

int_serial:
	PUSH	PSW
	PUSH	ACC

	JNB	RI, exit_int 	; check whether RI was set
	; received data on pin RxD
	MOV	A, SBUF		; SBUF contains received data
	CLR	RI		; reset RI bit in order to receive more data

	; echo data received on RxD through TxD
	MOV	SBUF, A
	JNB	TI, $
	CLR	TI

exit_int:
	POP 	ACC
	POP	PSW
	RETI			; return from interrupt service routine

END
